﻿
var publisheroncall         = "oncall";
var publisheroncomplete     = "oncomplete";
var publisheronstatechange  = "onstatechange";
var publisherondial         = "ondial";
var publisheroninterview        = "oninterview";
var publisheronerror            = "onerror";
var publisheronprojectselection = "onprojectselection";

var publishercallbacks = [publisherondial, publisheronstatechange, publisheroncomplete, publisheroncall, publisheroninterview, publisheronprojectselection, publisheronerror ];

function callbackobject(oncall, onstatechage, ondial, oncomplete, oninterview, onerror) {
    this.oncall = oncall;
    this.onstatechange = onstatechage;
    this.ondial = ondial;
    this.oncomplete = oncomplete;
    this.oninterview = oninterview;
    this.onerror    = onerror;
    this.onprojectselection = null ;
}


function callbacktag() {
    this.ondial             = publisherondial;
    this.oncomplete         = publisheroncomplete;
    this.onstatechange      = publisheronstatechange;
    this.oncall             = publisheroncall;
    this.oninterview        = publisheroninterview;
    this.onprojectselection = publisheronprojectselection;
    this.onerror            = publisheronerror;
}

//
//  Cette classe permet de publier des evenements au monde exterieur pour faciliter les futurs integration. Developper pour in-house
//  pour faciliter l'integration avec leur outil de callback
//

function eventPublisher() {

    var m_EventPublisher        = this;
    m_EventPublisher.m_Callback = {};
    m_EventPublisher.m_LastStatus;
	m_EventPublisher.m_Tag ;

    //
    //  Publication des evenements par voxco.agent.
    //
    this.publish = function (event, userdata) {

        switch (event) {

            //
            // malheureusement dans voxco.agent sur les changements d'etats , nous pouvons recevoir 10 fois idle . 
            // Ici nous faisons un traitement pour s'assurer de l'envoyer une seule fois.
            //
            //

            case publisheronstatechange:

                if (userdata == undefined || userdata.length == 0)
                    return;

                if( userdata == m_EventPublisher.m_LastStatus  )
                    return ;

                m_EventPublisher.m_LastStatus = userdata;
                break;

            default:
                break ;
        }


        var callback = m_EventPublisher.m_Callback[event] ;
        if (callback == undefined || callback == null ) {
            return;
        }

        //
        //  Publication du messages au script externe.
        //
        var args = [].slice.call(arguments, 1);
        callback.apply(this, args);
        return;
    }

	this.getCallbackTag = function(){
		
		if( m_EventPublisher.m_Tag == undefined )
			m_EventPublisher.m_Tag = new callbacktag() ;
		
		return m_EventPublisher.m_Tag ;
	}

	
    this.subscribe = function (usercallback) {

        //
        // enregistrements des callback pour les notifications.  
        //

        for (var item in publishercallbacks) {

            var name = publishercallbacks[item];
            if (usercallback[name] != undefined && usercallback[name] != null) {
                m_EventPublisher.m_Callback[name] = usercallback[name];
            }

        }
        
        return;
    }
};


var gEventPublisher = new eventPublisher();